<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "include/controlloLogin.php";
    
    $datiStatistiche   = $geecomDb->leggiSingolaRiga("geecB_statistiche",1);
    $impostazioniMotoreRicerca = $geecomDb->leggiSingolaRiga("geecB_impostazioniRicerca",1);

    $dataOggi          = new DateTime();
    $dataInstallazione = new DateTime($datiStatistiche["dataInstallazione"]);
    $differenzaGiorni  = ($dataOggi->diff($dataInstallazione))->days;
    
    $analisiSito       = calcoloStatoSito($impostazioni, $geecomDb);
    $totaleRicercheEffettuate = $geecomDb->sommaValoriColonna("numeroRicerche","geecB_ricercheEffettuate");
    $data1MeseFa = date("Y-m-d", strtotime("- 30 days"));
    $totaleRicercheEffettuate1Mese      = $geecomDb->sommaValoriColonna("numeroRicerche","geecB_ricercheEffettuate",["ultimaRicerca"=>">'$data1MeseFa'"]);
    $data7GiorniFa = date("Y-m-d", strtotime("- 7 days"));
    $totaleRicercheEffettuate1Settimana = $geecomDb->sommaValoriColonna("numeroRicerche","geecB_ricercheEffettuate",["ultimaRicerca"=>">'$data7GiorniFa'"]);    
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title>Amministrazione di Geecom CMS - statistiche</title>
        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
    </head>
    
    <body>
        
        <header>  
            <?php  
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>
        
        <main role="main" class="bg-light" id="main">
            <div id="dashboard" class="container-fluid">
                <div class="row">
                    <div class="col-sm-5 col-lg-4 col-xl-3 py-4">
                        <div id="riepilogo-statistiche" >

                            <div class="alert border-<?php echo $analisiSito["classeBoxUtilizzo"]; ?> text-<?php echo $analisiSito["classeBoxUtilizzo"]; ?> text-center mb-0 seo text-white">
                                <h6><i class="<?php echo $analisiSito["icona"]; ?>"></i> Il tuo punteggio SEO è <strong><?php echo ceil($analisiSito["punteggioSito"]); ?>/100</strong></h6>
                                <hr class="my-2">
                                <p class="mb-0"><?php confrontoMediaPunteggio(ceil($analisiSito["punteggioSito"])); ?><i class="fas fa-question-circle" data-toggle="tooltip" data-placement="bottom" title="Il punteggio medio dei siti Geecom è di 47 punti"></i></p>
                            </div>
                            <hr>
                            <p><i class="far fa-calendar-alt"></i> La piattaforma è attiva dal <?php echo date("d/m/Y",strtotime($datiStatistiche["dataInstallazione"])) ?> (<?php echo $differenzaGiorni ?> giorni)</p>

                            <?php 
                                $queryRecordVisite = "SELECT * FROM geecB_visualizzazioniGiornaliere ORDER BY visualizzazioni DESC LIMIT 1";
                                $risRecordVisite   = $geecomDb->eseguiQueryLettura($queryRecordVisite);
                                if($risRecordVisite->num_rows>0) {
                                    $datiRecordVisite = $risRecordVisite->fetch_assoc();
                                    ?>
                                    <p><i class="fas fa-trophy"></i> Record di visite: <?php echo $datiRecordVisite["visualizzazioni"] ?>  il <?php echo date("d/m/Y",strtotime($datiRecordVisite["data"])) ?></p>
                                    <?php
                                }

                                if($differenzaGiorni>7) {
                                    $dataMinima = date('Y-m-d',strtotime('-7 days'));

                                    $queryRecordVisite = "SELECT * FROM geecB_visualizzazioniGiornaliere WHERE data>'$dataMinima' ORDER BY visualizzazioni DESC LIMIT 1";
                                    $risRecordVisite   = $geecomDb->eseguiQueryLettura($queryRecordVisite);
                                    ?>
                                    <p><i class="fas fa-trophy"></i> Record di visite ultima settimana: <?php echo $datiRecordVisite["visualizzazioni"] ?>  il <?php echo date("d/m/Y",strtotime($datiRecordVisite["data"])) ?></p>
                                    <?php
                                }

                                if($differenzaGiorni>30) {
                                    $dataMinima = date('Y-m-d',strtotime('-1 month'));

                                    $queryRecordVisite = "SELECT * FROM geecB_visualizzazioniGiornaliere WHERE data>'$dataMinima' ORDER BY visualizzazioni DESC LIMIT 1";
                                    $risRecordVisite   = $geecomDb->eseguiQueryLettura($queryRecordVisite);
                                    ?>
                                    <p><i class="fas fa-trophy"></i> Record di visite ultimo mese: <?php echo $datiRecordVisite["visualizzazioni"] ?>  il <?php echo date("d/m/Y",strtotime($datiRecordVisite["data"])) ?></p>
                                    <?php
                                }
                            ?>
                            <p><i class="far fa-chart-bar"></i> Visite oggi: <?php echo $datiStatistiche["visiteGiornaliere"]; ?></p>
                        </div>
                    </div>

                    <!-- Colonna principale -->
                    <div class="col-sm-7 col-lg-8 col-xl-9 py-4" id="riepilogoStatistiche">

                        <div class="mb-3">
                            <?php 
                                if($differenzaGiorni<2) {
                            ?>
                                    <div class="alert alert-info">Il grafico delle visualizzazioni sarà disponibile a partire da 3 giorni dopo la creazione del sito</div>
                            <?php
                                }
                                else {
                            ?>
                                    <div id="graficoVisualizzazioni"></div>
                            <?php
                                }
                            ?>
                        </div>

                        <div class="card mb-4 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#ricerche">
                                <a class="card-title">
                                    Ricerche
                                </a>
                            </div>
                            <div id="ricerche" class="collapse show">
                                <div class="card-body">
                                    <?php
                                        if($impostazioniMotoreRicerca["salvaRicercheUtenti"]!="si") {
                                    ?>
                                            <div class="alert alert-info">Attiva il salvataggio della ricerca utente per visualizzare questo tipo di statistiche</div>
                                    <?php
                                        }
                                        else if($geecomDb->contaRigheTabella("geecB_ricercheEffettuate")==0) {
                                    ?>
                                            <div class="alert alert-info">Non sono ancora state effettuate ricerche nel tuo sito web</div>
                                    <?php
                                        }
                                        else {
                                            ?> 
                                            <h5>Parole più ricercate:</h5>
                                            <div class="row">
                                                <div class="col-xl-4">
                                                    <div class="d-flex justify-content-between">
                                                        <span>Totale (<?= $totaleRicercheEffettuate ?> ricerche)</span>
                                                    </div>
                                                    <hr>
                                                    <div id="graficoChiavi"></div>
                                                </div>

                                                <div class="col-xl-4">
                                                    <?php 
                                                        if($totaleRicercheEffettuate1Mese>0) {
                                                            ?>
                                                            Ultimo mese (<?= $totaleRicercheEffettuate1Mese ?> ricerche)
                                                            <hr>
															<div id="graficoChiavi1Mese"></div>
                                                            <?php
                                                        }
                                                        else {
                                                            ?>
                                                            <div class="alert alert-info">Non sono ancora state effettuate ricerche nell'ultimo mese</div>
                                                            <?php                                                            
                                                        }
                                                    ?>
                                                </div>

                                                <div class="col-xl-4">
                                                    <?php 
                                                        if($totaleRicercheEffettuate1Settimana>0) {
                                                            ?>
                                                            Ultima settimana (<?= $totaleRicercheEffettuate1Settimana ?> ricerche)
                                                            <hr>
															<div id="graficoChiavi1Settimana"></div>
                                                            <?php
                                                        }
                                                        else {
                                                            ?>
                                                            <div class="alert alert-info">Non sono ancora state effettuate ricerche nell'ultima settimana</div>
                                                            <?php                                                            
                                                        }
                                                    ?>
                                                </div>
                                            </div>
                                            <?php    
                                        }
                                    ?>
                                </div>
                                <?php 
                                    if($totaleRicercheEffettuate>0) {
                                        ?>                                
                                        <div class="card-footer text-right">
                                            <a class="badge badge-pill badge-primary ml-2"href="ricercheEffettuate.php"><i class="fas fa-long-arrow-alt-right mr-1"></i>Vedi tutte</a>
                                        </div>
                                        <?php
                                    }
                                ?>
                            </div>
                        </div>

                        <div class="card mb-4 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#interazioniSito">
                                <a class="card-title">
                                    Interazioni
                                </a>
                            </div>
                            <div id="interazioniSito" class="collapse show">
                                <div class="card-body">
                                    <div class="row">
                                        <?php 
                                            $numeroCommenti  = $geecomDb->contaRigheTabella("geecB_commenti");
                                            if($numeroCommenti>10) {
                                                $faccinaCommmenti = "fas fa-smile";
                                                $classeCommmenti  = ($risCommmenti->num_rows>2) ? "text-danger" : "text-warning";
                                                $fraseCommmenti   = "Ottimo!";
                                                $numeroCommmenti    = $risCommmenti->num_rows;
                                            }
                                            else if($numeroCommenti>3) {
                                                $faccinaCommmenti = "fas fa-meh";
                                                $classeCommmenti  = "text-warning";
                                                $fraseCommmenti   = "Dobbiamo migliorare!";
                                                $numeroCommmenti  = 0;                                                            
                                            }
                                            else {
                                                $faccinaCommmenti = "fas fa-frown";
                                                $classeCommmenti  = "text-danger";
                                                $fraseCommmenti   = "Dobbiamo migliorare!";
                                                $numeroCommmenti  = 0;
                                            }
                                            stampaBoxStatistica("Commenti ricevuti",$classeCommmenti,$faccinaCommmenti,$numeroCommenti,$fraseCommmenti,"gestioneCommenti.php","text-center");

                                            $numeroEmailInviate = $geecomDb->sommaValoriColonna("contatoreInvii","geec_form");
                                            if($numeroEmailInviate>10) {
                                                $faccinaSegnalazioni = "fas fa-smile";
                                                $classeSegnalazioni  = "text-success";
                                                $fraseSegnalazioni   = "Ottimo!";
                                            }
                                            else if($numeroEmailInviate>=1){
                                                $faccinaSegnalazioni = "fas fa-meh";
                                                $classeSegnalazioni  = "text-warning";
                                                $fraseSegnalazioni   = "Dobbiamo migliorare!";
                                            }
                                            else {
                                                $faccinaCommmenti = "fas fa-frown";
                                                $classeCommmenti  = "text-danger";
                                                $fraseCommmenti   = "Dobbiamo migliorare!";
                                                $numeroEmailInviate  = 0;
                                            }
                                            stampaBoxStatistica("Email ricevute",$classeCommmenti,$faccinaCommmenti,$numeroEmailInviate,$fraseCommmenti,"componenti/form","text-center");

                                            $clickInvitoAzione = $geecomDb->sommaValoriColonna("numeroClick","geec_invitiAzione");
                                            if($clickInvitoAzione>10) {
                                                $faccinaSegnalazioni = "fas fa-smile";
                                                $classeSegnalazioni  = "text-success";
                                                $fraseSegnalazioni   = "Ottimo!";
                                            }
                                            else if($clickInvitoAzione>=1){
                                                $faccinaSegnalazioni = "fas fa-meh";
                                                $classeSegnalazioni  = "text-warning";
                                                $fraseSegnalazioni   = "Dobbiamo migliorare!";
                                            }
                                            else {
                                                $faccinaCommmenti = "fas fa-frown";
                                                $classeCommmenti  = "text-danger";
                                                $fraseCommmenti   = "Dobbiamo migliorare!";
                                                $clickInvitoAzione  = 0;
                                            }
                                            stampaBoxStatistica("Click su inviti all'azione",$classeCommmenti,$faccinaCommmenti,$clickInvitoAzione,$fraseCommmenti,"componenti/invitoAzione","text-center");

                                            $clickSlider = $geecomDb->sommaValoriColonna("numeroClick","geec_slide");
                                            if($clickSlider>10) {
                                                $faccinaSegnalazioni = "fas fa-smile";
                                                $classeSegnalazioni  = "text-success";
                                                $fraseSegnalazioni   = "Ottimo!";
                                            }
                                            else if($clickSlider>=1){
                                                $faccinaSegnalazioni = "fas fa-meh";
                                                $classeSegnalazioni  = "text-warning";
                                                $fraseSegnalazioni   = "Dobbiamo migliorare!";
                                            }
                                            else {
                                                $faccinaCommmenti = "fas fa-frown";
                                                $classeCommmenti  = "text-danger";
                                                $fraseCommmenti   = "Dobbiamo migliorare!";
                                                $clickInvitoAzione  = 0;
                                            }
                                            stampaBoxStatistica("Click slider",$classeCommmenti,$faccinaCommmenti,$clickSlider,$fraseCommmenti,"componenti/slider","mb-lg-0 text-center");

                                            $numeroTabellePrezzi = $geecomDb->contaRigheTabella("geec_tabellePrezzi");
                                            if($numeroTabellePrezzi>0) {
                                                $clickTabellePrezzi = $geecomDb->sommaValoriColonna("numeroClick","geec_colonneTabellaPrezzi");
                                                if($clickTabellePrezzi>10) {
                                                    $faccinaSegnalazioni = "fas fa-smile";
                                                    $classeSegnalazioni  = "text-success";
                                                    $fraseSegnalazioni   = "Ottimo!";
                                                }
                                                else if($clickTabellePrezzi>=1){
                                                    $faccinaSegnalazioni = "fas fa-meh";
                                                    $classeSegnalazioni  = "text-warning";
                                                    $fraseSegnalazioni   = "Dobbiamo migliorare!";
                                                }
                                                else {
                                                    $faccinaCommmenti = "fas fa-frown";
                                                    $classeCommmenti  = "text-danger";
                                                    $fraseCommmenti   = "Dobbiamo migliorare!";
                                                    $clickTabellePrezzi  = 0;
                                                }
                                                stampaBoxStatistica("Click tabelle prezzi",$classeCommmenti,$faccinaCommmenti,$clickTabellePrezzi,$fraseCommmenti,"componenti/tabellaPrezzi","mb-lg-0 text-center");
                                            }
                                            else {

                                                $faccinaCommmenti = "fas fa-meh";
                                                $classeCommmenti  = "text-info";
                                                $fraseCommmenti   = "Non sono presenti tabelle";
                                                $clickTabellePrezzi  = "";

                                                stampaBoxStatistica("Click tabelle prezzi",$classeCommmenti,$faccinaCommmenti,$clickTabellePrezzi,$fraseCommmenti,"componenti/tabellaPrezzi","mb-lg-0 text-center");
                                            }

                                            $numeroBanner = $geecomDb->contaRigheTabella("geec_banner");
                                            if($numeroBanner>0) {
                                                $clickBanner = $geecomDb->sommaValoriColonna("numeroClickTotali","geec_campagneBanner");
                                                if($clickBanner>10) {
                                                    $faccinaSegnalazioni = "fas fa-smile";
                                                    $classeSegnalazioni  = "text-success";
                                                    $fraseSegnalazioni   = "Ottimo!";
                                                }
                                                else if($clickBanner>=1){
                                                    $faccinaSegnalazioni = "fas fa-meh";
                                                    $classeSegnalazioni  = "text-warning";
                                                    $fraseSegnalazioni   = "Dobbiamo migliorare!";
                                                }
                                                else {
                                                    $faccinaCommmenti = "fas fa-frown";
                                                    $classeCommmenti  = "text-danger";
                                                    $fraseCommmenti   = "Dobbiamo migliorare!";
                                                    $clickBanner      = 0;
                                                }
                                            }
                                            else {
                                                $faccinaCommmenti = "fas fa-meh";
                                                $classeCommmenti  = "text-info";
                                                $fraseCommmenti   = "Non sono presenti banner";
                                                $clickBanner      = "";
                                            }
                                            stampaBoxStatistica("Click banner",$classeCommmenti,$faccinaCommmenti,$clickBanner,$fraseCommmenti,"componenti/banner","mb-lg-0 text-center");
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#SEOpagine">
                                <a class="card-title">
                                    SEO pagine
                                </a>
                            </div>
                            <div id="SEOpagine" class="collapse show">
                                <div class="card-body">
                                    <div class="row">
                                        <?php 
                                            $numeroComunicazioniNonEfficaci         = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"pagina","punteggioSeo"=>"scadente"));
                                            $fraseComunicazioniNonEfficaci          = ($numeroComunicazioniNonEfficaci==0) ? "Ottimo!" : "Dobbiamo migliorare!";
                                            $classeFaccinaComunicazioniNonEfficaci  = ($numeroComunicazioniNonEfficaci==0) ? "fas fa-smile" : "fas fa-meh";
                                            $classeTestualeComunicazioniNonEfficaci = ($numeroComunicazioniNonEfficaci==0) ? "text-success" : "text-danger";
                                            stampaBoxStatistica("Comunicazioni non efficaci",$classeTestualeComunicazioniNonEfficaci,$classeFaccinaComunicazioniNonEfficaci,$numeroComunicazioniNonEfficaci,$fraseComunicazioniNonEfficaci,"gestioneContenuti.php?tipo=pagina&punteggioSeo=bassa","mb-lg-0 text-center");

                                            $numeroComunicazioniMediamenteEfficaci         = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"pagina","punteggioSeo"=>"discreta"));
                                            $fraseComunicazioniMediamenteEfficaci          = ($numeroComunicazioniMediamenteEfficaci==0) ? "Ottimo!" : "Dobbiamo migliorare!";
                                            $classeFaccinaComunicazioniMediamenteEfficaci  = ($numeroComunicazioniMediamenteEfficaci==0) ? "fas fa-smile" : "fas fa-meh";
                                            $classeTestualeComunicazioniMediamenteEfficaci = ($numeroComunicazioniMediamenteEfficaci==0) ? "text-success" : "text-danger";
                                            stampaBoxStatistica("Comunicazioni poco efficaci",$classeTestualeComunicazioniMediamenteEfficaci,$classeFaccinaComunicazioniMediamenteEfficaci,$numeroComunicazioniMediamenteEfficaci,$fraseComunicazioniMediamenteEfficaci,"gestioneContenuti.php?tipo=pagina&punteggioSeo=discreta","mb-lg-0 text-center");

                                            $numeroComunicazioniEfficaci         = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"pagina","punteggioSeo"=>"buona"));
                                            $fraseComunicazioniEfficaci          = ($numeroComunicazioniEfficaci==0) ? "Dobbiamo migliorare!" : "Ottimo!";
                                            $classeFaccinaComunicazioniEfficaci  = ($numeroComunicazioniEfficaci>0) ? "fas fa-smile" : "fas fa-meh";
                                            $classeTestualeComunicazioniEfficaci = ($numeroComunicazioniEfficaci>0) ? "text-success" : "text-warning";
                                            stampaBoxStatistica("Comunicazioni efficaci",$classeTestualeComunicazioniEfficaci,$classeFaccinaComunicazioniEfficaci,$numeroComunicazioniEfficaci,$fraseComunicazioniEfficaci,"gestioneContenuti.php?tipo=pagina&punteggioSeo=buona","mb-lg-0 text-center");
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#SEOarticoli">
                                <a class="card-title">
                                    SEO articoli
                                </a>
                            </div>

                            <div id="SEOarticoli" class="collapse show">
                                <div class="card-body">

                                    <div class="row">
                                        <?php 
                                            $numeroTotaleArticoli   = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo"));
                                            $numeroArticoliSEOScadente = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","punteggioSeo"=>"scadente"));
                                            if($numeroArticoliSEOScadente>15) {
                                                $faccinaSeoArticoli = "fas fa-frown";
                                                $classeSeoArticoli  = "text-danger";
                                                $fraseSeoArticoli   = "Dobbiamo migliorare!";
                                            }
                                            else if($numeroArticoliSEOScadente>0) {
                                                $faccinaSeoArticoli = "fas fa-meh";
                                                $classeSeoArticoli  = "text-warning";
                                                $fraseSeoArticoli   = "Dobbiamo migliorare!";
                                            }
                                            else {
                                                $faccinaSeoArticoli = "fas fa-smile";
                                                $classeSeoArticoli  = "text-success";
                                                $fraseSeoArticoli   = "Ottimo!";
                                                $numeroArticoliSEOScadente  = 0;
                                            }
                                            stampaBoxStatistica("Articoli con SEO scadente",$classeSeoArticoli,$faccinaSeoArticoli,$numeroArticoliSEOScadente,$fraseSeoArticoli,"gestioneContenuti.php?tipo=articolo&stato=aperto","mb-lg-0 text-center");

                                            $numeroTotaleArticoli   = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo"));
                                            $numeroArticoliSEODiscreta = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","punteggioSeo"=>"discreta"));
                                            if($numeroArticoliSEOScadente>15) {
                                                $faccinaSeoArticoli = "fas fa-frown";
                                                $classeSeoArticoli  = "text-danger";
                                                $fraseSeoArticoli   = "Dobbiamo migliorare!";
                                            }
                                            else if($numeroArticoliSEOScadente>0) {
                                                $faccinaSeoArticoli = "fas fa-meh";
                                                $classeSeoArticoli  = "text-warning";
                                                $fraseSeoArticoli   = "Dobbiamo migliorare!";
                                            }
                                            else {
                                                $faccinaSeoArticoli = "fas fa-smile";
                                                $classeSeoArticoli  = "text-success";
                                                $fraseSeoArticoli   = "Ottimo!";
                                                $numeroArticoliSEODiscreta  = 0;
                                            }
                                            stampaBoxStatistica("Articoli con SEO discreta",$classeSeoArticoli,$faccinaSeoArticoli,$numeroArticoliSEODiscreta,$fraseSeoArticoli,"gestioneContenuti.php?tipo=articolo&stato=aperto","mb-lg-0 text-center");

                                            $numeroArticoliSEOBuona = $geecomDb->contaRigheTabella("geecB_contenuti",array("tipo"=>"articolo","punteggioSeo"=>"buona"));
                                            $totaleArticoliConSeoNonOttimale = $numeroArticoliSEODiscreta + $numeroArticoliSEOScadente;
                                            if($totaleArticoliConSeoNonOttimale>15 || $numeroArticoliSEOBuona==0) {
                                                $faccinaSeoArticoli = "fas fa-frown";
                                                $classeSeoArticoli  = "text-danger";
                                                $fraseSeoArticoli   = "Dobbiamo migliorare!";
                                            }
                                            else if($totaleArticoliConSeoNonOttimale>0) {
                                                $faccinaSeoArticoli = "fas fa-meh";
                                                $classeSeoArticoli  = "text-warning";
                                                $fraseSeoArticoli   = "Dobbiamo migliorare!";
                                            }
                                            else {
                                                $faccinaSeoArticoli = "fas fa-smile";
                                                $classeSeoArticoli  = "text-success";
                                                $fraseSeoArticoli   = "Ottimo!";
                                            }
                                            stampaBoxStatistica("Articoli con SEO buona",$classeSeoArticoli,$faccinaSeoArticoli,$numeroArticoliSEOBuona,$fraseSeoArticoli,"gestioneContenuti.php?tipo=articolo&stato=aperto","mb-lg-0 text-center");

                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div><!-- /Colonna principale -->
            </div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/modalMenuComponenti.php";
                
        include "include/modal/cambiaPassword.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>  
	  
        <script>
            /*
             * Replace all SVG images with inline SVG
             */
            jQuery('img.svg').each(function(){
                var $img = jQuery(this);
                var imgID = $img.attr('id');
                var imgClass = $img.attr('class');
                var imgURL = $img.attr('src');

                jQuery.get(imgURL, function(data) {
                        // Get the SVG tag, ignore the rest
                        var $svg = jQuery(data).find('svg');

                        // Add replaced image's ID to the new SVG
                        if(typeof imgID !== 'undefined') {
                                $svg = $svg.attr('id', imgID);
                        }
                        // Add replaced image's classes to the new SVG
                        if(typeof imgClass !== 'undefined') {
                                $svg = $svg.attr('class', imgClass+' replaced-svg');
                        }

                        // Remove any invalid XML tags as per http://validator.w3.org
                        $svg = $svg.removeAttr('xmlns:a');

                        // Check if the viewport is set, if the viewport is not set the SVG wont't scale.
                        if(!$svg.attr('viewBox') && $svg.attr('height') && $svg.attr('width')) {
                                $svg.attr('viewBox', '0 0 ' + $svg.attr('height') + ' ' + $svg.attr('width'))
                        }

                        // Replace image with new SVG
                        $img.replaceWith($svg);

                }, 'xml');
            });
	  
        </script>
        <script src="../plugins/apexcharts/apexcharts.min.js" type="text/javascript"></script>
        <?php 
            array();
            $occorenzeTabellaVisualizzazioni = $geecomDb->contaRigheTabella("geecB_visualizzazioniGiornaliere");
            if($occorenzeTabellaVisualizzazioni>15) {
                $numeroPartenza = $occorenzeTabellaVisualizzazioni -15;
                $queryVisualizzazioni = "SELECT * FROM geecB_visualizzazioniGiornaliere LIMIT $numeroPartenza, 15";
            }
            else {
                $queryVisualizzazioni = "SELECT * FROM geecB_visualizzazioniGiornaliere ";
            }
            
            $arrayVisualizzazioni = array();
            $arrayDate            = array();
            $risVisualizzazioni = $geecomDb->eseguiQueryLettura($queryVisualizzazioni);
            while($datiSingoloGiorno = $risVisualizzazioni->fetch_assoc()) {
                $arrayVisualizzazioni[count($arrayVisualizzazioni)] = $datiSingoloGiorno["visualizzazioni"];
                $arrayDate[count($arrayDate)]                       = date("d/m/Y", strtotime($datiSingoloGiorno["data"]));
            }
            
            // recupero dati grafico parole chiavi globale
            $arrayChiaviPiuUsate           = [];
            $arrayOccorrenzeChiaviPiuUsate = [];
            $numeroRicercheEffettuateUtenti = $geecomDb->contaRigheTabella("geecB_ricercheEffettuate");
            if($numeroRicercheEffettuateUtenti>5) {
                $queryRicercheEffettuate = "SELECT * FROM geecB_ricercheEffettuate ORDER BY numeroRicerche DESC LIMIT 4";
            }
            else {
                $queryRicercheEffettuate = "SELECT * FROM geecB_ricercheEffettuate ORDER BY numeroRicerche DESC";
            }
            
            $totaleRicerchePiuPopolari = 0;
            $risRicercheEffettuate = $geecomDb->eseguiQueryLettura($queryRicercheEffettuate);
            while($datiRicerca = $risRicercheEffettuate->fetch_assoc()) {
                $totaleRicerchePiuPopolari += $datiRicerca["numeroRicerche"];
                array_push($arrayChiaviPiuUsate,"'".$datiRicerca["parolaChiave"]."'");
                array_push($arrayOccorrenzeChiaviPiuUsate,$datiRicerca["numeroRicerche"]);
            }
            
            if(count($arrayChiaviPiuUsate)<=4) {
                array_push($arrayChiaviPiuUsate,"'altro'");
                array_push($arrayOccorrenzeChiaviPiuUsate,$totaleRicercheEffettuate-$totaleRicerchePiuPopolari);
            }
        ?>
        <script>
            var options = {
                series: [{
                    name: "Visualizzazioni",
                    data: [<?= implode(",", $arrayVisualizzazioni) ?>]
                }],
                chart: {
                    height: 350,
                    type: 'line',
                    zoom: {
                        enabled: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    curve: 'straight',
                },
                colors: ['#018394', '#dd3b15', '#f7a616'],
                title: {
                    text: 'Visualizzazioni negli ultimi 15 giorni',
                    align: 'left'
                },
                grid: {
                    row: {
                        colors: ['#f3f3f3', 'transparent'], // takes an array which will be repeated on columns
                        opacity: 0.5
                    },
                },
                xaxis: {
                    categories: [<?php echo "'".implode("','", $arrayDate)."'" ?>],
                }
            };

            var chart = new ApexCharts(document.querySelector("#graficoVisualizzazioni"), options);
            chart.render();

            // grafico delle chiavi di ricercha più usate
            var opzioniGraficoChiavi = {
                series: [<?= implode(",", $arrayOccorrenzeChiaviPiuUsate) ?>],
                chart: {
                width: 400,
                type: 'pie',
            },
			colors: ['#028394', '#359ca9', '#66b4be', '#99cdd4', '#cce6e9'],
            labels: [<?= implode(",", $arrayChiaviPiuUsate) ?>],
            responsive: [{
              breakpoint: 480,
              options: {
                chart: {
                  width: 200
                },
                legend: {
                  position: 'bottom'
                }
              }
            }]
            };

            var graficoChiavi = new ApexCharts(document.querySelector("#graficoChiavi"), opzioniGraficoChiavi);
            graficoChiavi.render();
	      
        </script>
        <?php 
            if($totaleRicercheEffettuate1Mese>0) {
                
                $arrayChiaviPiuUsate1MeseFa           = [];
                $arrayOccorrenzeChiaviPiuUsate1MeseFa = [];
                $numeroRicercheEffettuateUtenti = $geecomDb->contaRigheTabella("geecB_ricercheEffettuate");
                if($numeroRicercheEffettuateUtenti>5) {
                    $queryRicercheEffettuate = "SELECT * FROM geecB_ricercheEffettuate WHERE ultimaRicerca>'$data1MeseFa' ORDER BY numeroRicerche DESC LIMIT 4";
                }
                else {
                    $queryRicercheEffettuate = "SELECT * FROM geecB_ricercheEffettuate WHERE ultimaRicerca>'$data1MeseFa' ORDER BY numeroRicerche DESC";
                }

                $totaleRicerchePiuPopolari = 0;
                $risRicercheEffettuate = $geecomDb->eseguiQueryLettura($queryRicercheEffettuate);
                while($datiRicerca = $risRicercheEffettuate->fetch_assoc()) {
                    $totaleRicerchePiuPopolari += $datiRicerca["numeroRicerche"];
                    array_push($arrayChiaviPiuUsate1MeseFa,"'".$datiRicerca["parolaChiave"]."'");
                    array_push($arrayOccorrenzeChiaviPiuUsate1MeseFa,$datiRicerca["numeroRicerche"]);
                }

                if(count($arrayChiaviPiuUsate)<=4) {
                    array_push($arrayChiaviPiuUsate1MeseFa,"'altro'");
                    array_push($arrayOccorrenzeChiaviPiuUsate1MeseFa,$totaleRicercheEffettuate1Mese-$totaleRicerchePiuPopolari);
                }

                ?>
                <script>
                    // grafico delle chiavi di ricercha più usate
                    var opzioniGraficoChiavi = {
                        series: [<?= implode(",", $arrayOccorrenzeChiaviPiuUsate) ?>],
                        chart: {
                        width: 400,
                        type: 'pie',
                    },
					colors: ['#028394', '#359ca9', '#66b4be', '#99cdd4', '#cce6e9'],
                    labels: [<?= implode(",", $arrayChiaviPiuUsate) ?>],
                    responsive: [{
                      breakpoint: 480,
                      options: {
                        chart: {
                          width: 200
                        },
                        legend: {
                          position: 'bottom'
                        }
                      }
                    }]
                    };

                    var graficoChiavi = new ApexCharts(document.querySelector("#graficoChiavi1Mese"), opzioniGraficoChiavi);
                    graficoChiavi.render();

                </script>
                <?php
            }
            
            if($totaleRicercheEffettuate1Settimana>0) {
                
                $arrayChiaviPiuUsate1SettimanaFa           = [];
                $arrayOccorrenzeChiaviPiuUsate1SettimanaFa = [];
                $numeroRicercheEffettuateUtenti = $geecomDb->contaRigheTabella("geecB_ricercheEffettuate");
                if($numeroRicercheEffettuateUtenti>5) {
                    $queryRicercheEffettuate = "SELECT * FROM geecB_ricercheEffettuate WHERE ultimaRicerca>'$data7GiorniFa' ORDER BY numeroRicerche DESC LIMIT 4";
                }
                else {
                    $queryRicercheEffettuate = "SELECT * FROM geecB_ricercheEffettuate WHERE ultimaRicerca>'$data7GiorniFa' ORDER BY numeroRicerche DESC";
                }

                $totaleRicerchePiuPopolari = 0;
                $risRicercheEffettuate = $geecomDb->eseguiQueryLettura($queryRicercheEffettuate);
                while($datiRicerca = $risRicercheEffettuate->fetch_assoc()) {
                    $totaleRicerchePiuPopolari += $datiRicerca["numeroRicerche"];
                    array_push($arrayChiaviPiuUsate1SettimanaFa,"'".$datiRicerca["parolaChiave"]."'");
                    array_push($arrayOccorrenzeChiaviPiuUsate1SettimanaFa,$datiRicerca["numeroRicerche"]);
                }

                if(count($arrayChiaviPiuUsate)<=4) {
                    array_push($arrayChiaviPiuUsate1SettimanaFa,"'altro'");
                    array_push($arrayOccorrenzeChiaviPiuUsate1SettimanaFa,$totaleRicercheEffettuate1Settimana-$totaleRicerchePiuPopolari);
                }

                ?>
                <script>
                    // grafico delle chiavi di ricercha più usate
                    var opzioniGraficoChiavi1Settimana = {
                        series: [<?= implode(",", $arrayOccorrenzeChiaviPiuUsate) ?>],
                        chart: {
                        width: 400,
                        type: 'pie',
                    },
					colors: ['#028394', '#359ca9', '#66b4be', '#99cdd4', '#cce6e9'],
                    labels: [<?= implode(",", $arrayChiaviPiuUsate) ?>],
                    responsive: [{
                      breakpoint: 480,
                      options: {
                        chart: {
                          width: 200
                        },
                        legend: {
                          position: 'bottom'
                        }
                      }
                    }]
                    };

                    var graficoChiavi1Settimana = new ApexCharts(document.querySelector("#graficoChiavi1Settimana"), opzioniGraficoChiavi1Settimana);
                    graficoChiavi1Settimana.render();

                </script>
                <?php
            }
        ?>
  </body>
</html>

<?php

    function stampaBoxStatistica($titoloSezione,$classeTestuale,$classeFaccina,$numeroELementi,$frase,$link,$classeAggiuntivaDiv = "") {
        ?>
        <div class="col-lg-4 mb-5 <?php echo $classeAggiuntivaDiv ?> text-center">
            <h6 class="<?php echo $classeTestuale ?>"> <i class="<?php echo $classeFaccina ?>"></i></h6>
            <h6 class="<?php echo $classeTestuale ?>"><strong><?php echo $numeroELementi ?></strong> <?php echo $titoloSezione ?></h6>
            <p><?php echo $frase ?></p>
            <a href="<?php echo $link ?>" class="btn btn-primary btn-block btn-sm text-white leggi-tutto mt-3">Dettagli</a>
        </div>
        <?php
    }